from django.shortcuts import render, get_object_or_404
from .models import Product, Category

def home(request):
    # Get featured products for the carousel
    featured_products = Product.objects.filter(is_active=True, in_stock=True)[:4]
    context = {
        'featured_products': featured_products,
    }
    return render(request, 'store/home.html', context)

def product_list(request):
    products = Product.objects.filter(is_active=True)
    categories = Category.objects.all()
    
    # Filter by category if specified
    category_slug = request.GET.get('category')
    if category_slug:
        products = products.filter(category__slug=category_slug)
    
    # Filter by size if specified
    size_filter = request.GET.get('size')
    if size_filter:
        products = products.filter(volume=size_filter)
    
    context = {
        'products': products,
        'categories': categories,
        'selected_category': category_slug,
        'selected_size': size_filter,
    }
    return render(request, 'store/product_list.html', context)

def product_detail(request, product_id):
    product = get_object_or_404(Product, id=product_id, is_active=True)
    context = {'product': product}
    return render(request, 'store/product_detail.html', context)

def contact_us(request):
    return render(request, 'store/contact_us.html')

def about_us(request):
    return render(request, 'store/about_us.html')